<?php
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// Optionally load public Firebase client config from a server-side secrets file
$externalSecrets = '/home/monazem/public_html/secrets-yicen.php'; // Update this path based on your exact cPanel username from sidebar
if (@is_readable($externalSecrets)) {
  require $externalSecrets;
}

$firebase = [
  // Public Firebase Web config (safe to expose to browser)
  'apiKey'            => defined('FIREBASE_API_KEY') ? FIREBASE_API_KEY : 'YOUR_PUBLIC_FIREBASE_API_KEY',
  'authDomain'        => defined('FIREBASE_AUTH_DOMAIN') ? FIREBASE_AUTH_DOMAIN : 'your-app.firebaseapp.com',
  'databaseURL'       => defined('FIREBASE_DATABASE_URL') ? FIREBASE_DATABASE_URL : 'https://your-app-default-rtdb.firebaseio.com',
  'projectId'         => defined('FIREBASE_PROJECT_ID') ? FIREBASE_PROJECT_ID : 'your-app',
  'storageBucket'     => defined('FIREBASE_STORAGE_BUCKET') ? FIREBASE_STORAGE_BUCKET : 'your-app.appspot.com',
  'messagingSenderId' => defined('FIREBASE_MESSAGING_SENDER_ID') ? FIREBASE_MESSAGING_SENDER_ID : '000000000000',
  'appId'             => defined('FIREBASE_APP_ID') ? FIREBASE_APP_ID : '1:000000000000:web:0000000000000000',
  'measurementId'     => defined('FIREBASE_MEASUREMENT_ID') ? FIREBASE_MEASUREMENT_ID : 'G-XXXXXXXXXX',
];

echo json_encode([
  'firebase' => $firebase,
  'chat' => [ 'apiBaseUrl' => '/api' ],
  'security' => [
    'environment' => 'production',
    'enableConsoleLogs' => false,
    'configCleanupDelay' => 0
  ]
]);
