(function() {
  // Load safe, public config from the server
  fetch('/api/config.php', { credentials: 'same-origin' })
    .then(r => r.json())
    .then(cfg => {
      window.FIREBASE_CONFIG = cfg.firebase;
      window.API_CONFIG = { baseUrl: cfg.chat.apiBaseUrl };
      window.CHAT_API_CONFIG = { apiBaseUrl: cfg.chat.apiBaseUrl };
      window.SECURITY_CONFIG = cfg.security || { environment: 'production' };
      window.CONFIG_LOADED = true;
    })
    .catch(err => {
      console.error('Failed to load config:', err);
    });
})();